import misc.Debug;
import types.DataClass;
import types.Rahmen;


class StopAndWait extends Protocol {

    // Variables
    int m_iLastAckSend;

	public StopAndWait(Computer a)	{
		super(a);
		sendWindow = new DataClass(2,1);
		m_Buffer1.setMaxSize(sendWindow.maxWindowSize());
		receiveWindow = new DataClass(2,1);
		m_Buffer2.setMaxSize(receiveWindow.maxWindowSize());
		sendWindow.lowerBound(0);
		sendWindow.upperBound(0);
		receiveWindow.lowerBound(0);
		receiveWindow.upperBound(0);
		m_iTimeSteps = 4;
		m_iLastAckSend = -1;
	}
	public void Work() {
		switch (m_Event) {
		case 0: // Event frame send
		    // This Event happens, is Layer n+1 wants to send some data
		    // First check, if sending is allowed
		    if (sendWindow.windowSize()<sendWindow.maxWindowSize()) {
		        // first check, if sequence number belongs to a frame that must be retransmitted
		        Rahmen frame;
		        frame=m_Buffer1.getFrame(sendWindow.upperBound());
		        if (frame==null) {
		            // otherwise
		            // Create new frame with sequencenumber of upperbound
    		        frame = new Rahmen(sendWindow.upperBound(),-1,Rahmen.DATA,m_Computer.getData());
    		        // put it in the buffer
    		        m_Buffer1.addFrame(frame);
		        }
		        // Mark frame as undamaged
		        frame.repair();
		        // Put frame on the way
		        m_Computer.lowerLayerSend(frame);
		        // Start timer (in this case, one timer for each sequence number)
		        // The timer expires after 3 abstract timesteps
		        m_Computer.timer().insertTimer(1,m_iTimeSteps);
		        sendWindow.incUpperBound(1);
		    }
			break;
		case 1: // Event Accept one Frame
		    // This Event happens, if Layer n+1 is ready to accept and acknowledge
		    // a dataFrame waiting at Layer n
		    // First check, if any Frame is available
		    if (m_InBox.size()>0) {
		        // Take first available frame and remove it from the InBox
		        Rahmen frame = (Rahmen)m_InBox.elementAt(0);
		        m_InBox.removeElement(frame);
		        // Distinguish type of Frame
                if (frame.iKind()==Rahmen.DATA) {
                    // A Data frame arrived
                    // Accept frame and send Acknowledgment
                    m_Computer.writeData(frame.data());
                    m_Computer.lowerLayerSend(new Rahmen(0,receiveWindow.lowerBound(),Rahmen.ACK));
                    m_iLastAckSend = receiveWindow.lowerBound();
                    receiveWindow.incLowerBound(1);
    	        }

            }
			break;
	    case 2: // Event frame arriving from Lowerlayer
	        // This Event happens, if a Rahmen arrives from Layer n-1
            if (m_Frame.iKind()==Rahmen.DATA) {
                // A Data frame arrived
                // Check the sequence Number
                if (m_Frame.seqNr()==receiveWindow.upperBound()) {
                    // Accept frame and advance LowerBound
                    receiveWindow.incUpperBound(1);
        	        // put the frame in the InBox
                    m_InBox.addElement(m_Frame);
    	        }
    	        else {
    	            // Out of sequence
    	            // retransmit Acknowledgement
                    m_Computer.lowerLayerSend(new Rahmen(0,m_iLastAckSend,Rahmen.ACK));
                }
    	    }
	        if (m_Frame.iKind()==Rahmen.ACK) {
	            // An Acknowledgement arrived, check if it is the right one
	            if ((m_Frame.seqNrAck()==sendWindow.lowerBound())&&(sendWindow.windowSize()>0)) {
    	            // Accept Ack, stop timer and switch to next sequence number
                    m_Computer.timer().removeTimer(1);
                    m_Buffer1.removeFrame(sendWindow.lowerBound());
                    sendWindow.incLowerBound(1);
                }
            }
            break;
		case 4: // Event Timeout
		    sendWindow.incUpperBound(-1);
		    break;
		}
	}
}
